function [celllabel,ncell,nfiles] = cutresultsfunction()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Reads Results.csv and divides it in nfiles called 'Results1.csv' etc

%%% INPUT ARGUMENTS

%%% 'Results.csv' must be in the same folder

%%% OUTPUT ARGUMENTS

%%% celllabel = each row rapresents one cell (name,X,Y)
%%% ncell = total number of cells
%%% nfiles = total number of Results.csv files (and timetraces files)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Reads Results file and saves cells labels and positions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

celllabel = csvread('Results.csv',1,0); %Reads the Results cvs from ImageJ
cellname = celllabel(:,1); %first column of Results indicates the names of the cells
ncell = size(celllabel,1); %number of cells detected


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Cuts Results file in groups to analyze traces in ImageJ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nfiles = ceil(ncell/148); %number of sets that will be analized

ii = 0;

for ii = 1:nfiles
    
    tmp = celllabel( (ii*148+1)-148 : min(ii*148,ncell), [1 2]);
    csvwrite(sprintf('Results%d.csv',ii),tmp,1,0); %saves in different csv files the subgroups of ROIs
    
end

for ii = 1:nfiles
    
    name = sprintf('Results%d.csv',ii);
    tmp = csvread(name,1,0);
    X = tmp(:,1);
    Y = tmp(:,2);
    T = table(X,Y);
    writetable(T,name,'Delimiter',',','QuoteStrings',true);
    
end

movefile('Results.csv','ResultsALL.csv');

clearvars ii name T tmp X Y;
end